
local t = Def.ActorFrame {
	Def.Sprite{
		BeginCommand=cmd(playcommand,"SetGraphic";);
		InitCommand=cmd(horizalign,right);
		CurrentSongChangedMessageCommand=cmd(finishtweening;playcommand,"SetGraphic";);
	
		SetGraphicCommand=function(self, params)
			local curStage = GAMESTATE:GetCurrentStage();
			local curStageNum = GAMESTATE:GetCurrentStageIndex(); -- 0-based
			local maxStages = PREFSMAN:GetPreference("SongsPerPlay")

			local song = GAMESTATE:GetCurrentSong()
			if song then
				local songStages = 1;
				if song:IsLong() then
					songStages = 2
				elseif song:IsMarathon() then
					songStages = 3
				end
				local totalStages = curStageNum+songStages

				if totalStages == maxStages and not GAMESTATE:IsEventMode() then
					curStage = 'Stage_Final'
				else
					if not curStage == 'Stage_Event' then
						local stageStr = FormatNumberAndSuffix(curStageNum+1)
						curStage = 'Stage_'..stageStr
					end
				end
				self:Load(THEME:GetPathG("","_stages/_selmusic "..curStage));
			else

				if totalStages == PREFSMAN:GetPreference("SongsPerPlay") then
					Stage = 'Stage_Final';
					self:Load(THEME:GetPathG("","_stages/_selmusic "..Stage));
				end
			
				if not curStage == 'Stage_Event' then
					local stageStr = FormatNumberAndSuffix(curStageNum+1)
					curStage = 'Stage_'..stageStr
				end
			end
		end
	};

};

return t;
